const API_URL = process.env.EXPO_PUBLIC_API_URL || 'http://localhost:4000';

let accessToken: string | null = null;

export function setAccessToken(token: string) {
  accessToken = token;
}

export function getAccessToken() {
  return accessToken;
}

export async function api<T>(path: string, options: RequestInit = {}): Promise<T> {
  const res = await fetch(`${API_URL}${path}`, {
    ...options,
    headers: {
      'Content-Type': 'application/json',
      ...(accessToken && { Authorization: `Bearer ${accessToken}` }),
      ...options.headers,
    },
  });
  if (!res.ok) {
    const err = await res.json().catch(() => ({ message: res.statusText }));
    throw new Error(err.message || 'Request failed');
  }
  return res.json();
}

export const authApi = {
  login: (email: string, password: string) =>
    api<{ user: any; accessToken: string }>('/auth/login', {
      method: 'POST',
      body: JSON.stringify({ email, password }),
    }),
  logout: () => api<{ ok: boolean }>('/auth/logout', { method: 'POST' }),
};

export const tenantApi = {
  getMe: () => api<any>('/tenant/me'),
};

export const productApi = {
  listProducts: () => api<any[]>('/products'),
  listCategories: () => api<any[]>('/products/categories'),
  getProduct: (id: string) => api<any>(`/products/${id}`),
  updateProduct: (id: string, body: any) =>
    api<any>(`/products/${id}`, { method: 'PUT', body: JSON.stringify(body) }),
  createProduct: (body: any) =>
    api<any>('/products', { method: 'POST', body: JSON.stringify(body) }),
};
