import type { Metadata } from 'next';
import './globals.css';

export const metadata: Metadata = {
  title: 'Menü',
  description: 'QR Menü',
  manifest: '/manifest.json',
  themeColor: '#059669',
  viewport: 'width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no',
};

export default function RootLayout({ children }: { children: React.ReactNode }) {
  return (
    <html lang="tr">
      <head>
        <link rel="manifest" href="/manifest.json" />
        <script
          type="module"
          src="https://unpkg.com/@google/model-viewer/dist/model-viewer.min.js"
          async
        />
      </head>
      <body>{children}</body>
    </html>
  );
}
