import { Controller, Post, Body, UseGuards, Req } from '@nestjs/common';
import { UploadService } from './upload.service';
import { JwtAuthGuard, TenantGuard, SubscriptionGuard, RolesGuard, Roles } from '../auth/guards';
import { PresignedUploadDto } from './dto/presigned-upload.dto';

@Controller('upload')
@UseGuards(JwtAuthGuard, TenantGuard, SubscriptionGuard, RolesGuard)
@Roles('owner', 'admin', 'editor')
export class UploadController {
  constructor(private upload: UploadService) {}

  @Post('presigned')
  async getPresignedUrl(@Req() req: any, @Body() body: PresignedUploadDto) {
    return this.upload.getPresignedUrl(
      req.tenantId,
      req.user.id,
      body.productId,
      body.filename,
      body.contentType,
      body.type,
    );
  }
}
