import { Controller, Get, Param } from '@nestjs/common';
import { TenantService } from './tenant.service';

@Controller('public')
export class PublicMenuController {
  constructor(private tenant: TenantService) {}

  @Get('menu/:tenantSlug')
  async getMenu(@Param('tenantSlug') tenantSlug: string) {
    return this.tenant.getPublicMenu(tenantSlug);
  }

  @Get('menu/:tenantSlug/location/:locationId')
  async getMenuWithLocation(
    @Param('tenantSlug') tenantSlug: string,
    @Param('locationId') locationId: string,
  ) {
    return this.tenant.getPublicMenu(tenantSlug, locationId);
  }

  @Get('menu/:tenantSlug/location/:locationId/table/:tableId')
  async getMenuWithTable(
    @Param('tenantSlug') tenantSlug: string,
    @Param('locationId') locationId: string,
    @Param('tableId') tableId: string,
  ) {
    return this.tenant.getPublicMenu(tenantSlug, locationId, tableId);
  }
}
