import { ExecutionContext } from '@nestjs/common';
import { SubscriptionGuard } from './subscription.guard';
import { PrismaService } from '../../../prisma/prisma.service';

const mockPrisma = {
  subscription: { findUnique: jest.fn() },
};

describe('SubscriptionGuard', () => {
  let guard: SubscriptionGuard;

  beforeEach(() => {
    jest.clearAllMocks();
    guard = new SubscriptionGuard(mockPrisma as unknown as PrismaService);
  });

  it('allows super_admin without tenant check', async () => {
    const ctx = {
      switchToHttp: () => ({
        getRequest: () => ({ user: { platformRole: 'super_admin' } }),
      }),
    } as ExecutionContext;
    await expect(guard.canActivate(ctx)).resolves.toBe(true);
  });

  it('allows when subscription is active', async () => {
    mockPrisma.subscription.findUnique.mockResolvedValue({ status: 'active' });
    const ctx = {
      switchToHttp: () => ({
        getRequest: () => ({ user: { id: 'u1' }, tenantId: 't1' }),
      }),
    } as ExecutionContext;
    await expect(guard.canActivate(ctx)).resolves.toBe(true);
  });

  it('throws when subscription is canceled', async () => {
    mockPrisma.subscription.findUnique.mockResolvedValue({ status: 'canceled' });
    const ctx = {
      switchToHttp: () => ({
        getRequest: () => ({ user: { id: 'u1' }, tenantId: 't1', url: '/products' }),
      }),
    } as ExecutionContext;
    await expect(guard.canActivate(ctx)).rejects.toThrow('Aktif abonelik gerekli');
  });
});
